<?php $page_title = "Withdraw Funds" ?>
<?php include 'user_header.php';?>
        <!-- Stats -->
<!-- Stats -->
<div class="section mt-4">
    <!--<div class="section-heading d-flex justify-content-between align-items-center mb-3">-->
    <!--    <h2 class="title m-0">Withdrawal Statistics</h2>-->
    <!--</div>-->

    <div class="row mt-2">
        <div class="col-6 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-wrapper me-3">
                        <i class="fa-solid fa-hourglass-start text-primary"></i>
                    </div>
                    <div>
                        <div class="title text-muted">Pending Withdrawal</div>
                        <div class="value text-primary fw-bold"><?php echo $currency . $pending_withdrawal ?></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body d-flex align-items-center">
                    <div class="icon-wrapper me-3">
                        <i class="fa-solid fa-check-circle text-success"></i>
                    </div>
                    <div>
                        <div class="title text-muted">Confirmed Withdrawal</div>
                        <div class="value text-success fw-bold"><?php echo $currency . $confirm_withdrawal ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- * Stats -->

<style>
    /* Section Styling */
.section {
    padding: 0 15px;
}

.section-heading .title {
    font-size: 1.5rem;
    font-weight: 600;
}

/* Stat Box Styling */
.stat-box {
    transition: transform 0.2s, box-shadow 0.2s;
    border: 1px solid #e9ecef;
}

.stat-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15) !important;
}

.stat-box .card-body {
    padding: 1.25rem;
}

.stat-box .title {
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 0.5rem;
}

.stat-box .value {
    font-size: 1.25rem;
}

/* Icon Wrapper for Stat Box */
.icon-wrapper {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: #f1f3f5;
    border-radius: 50%;
}

.icon-wrapper i {
    font-size: 1.2rem;
}

/* Responsive Adjustments */
@media (max-width: 576px) {
    .section-heading .title {
        font-size: 1.3rem;
    }

    .row .col-6 {
        flex: 0 0 100%;
        max-width: 100%;
    }

    .stat-box .value {
        font-size: 1.1rem;
    }

    .icon-wrapper {
        width: 36px;
        height: 36px;
    }

    .icon-wrapper i {
        font-size: 1rem;
    }
}
</style>

      <div class="section mt-2">
            <div class="section-title">Withdrawal Transactions</div>
            <div class="card">

                <div class="table-responsive">
                    <table class="table" style="width:100%">
                        <thead>
                          <th style="color: black"; scope="col">S/N</th>
                          <th style="color: black"; scope="col">Name</th>
                          <th style="color: black"; scope="col">Amount</th>
                          <th style="color: black"; scope="col">Payment Gateway</th>
                          <th style="color: black"; scope="col">Wallet address</th>
                          <th style="color: black"; scope="col">Status</th>
                          <th style="color: black"; scope="col" class="">Date</th>
                        </thead>
                        <tbody>
                          <?php
                              $i = 1;
                              $sql = "SELECT * FROM transaction WHERE transaction_type = 'withdrawal' AND transaction_user_id = '$user_id' ORDER BY transaction_id DESC";
                              $result = $connection->query($sql);
                              while ($row = $result->fetch_assoc()) {
                                  $trnx_id = $row['transaction_id'];
                                  $amount = $row['transaction_amount'];
                                  $gateway = $row['t_mode'];
                                  $wallet_address = $row['wallet_address'];
                                  $status = $row['transaction_status'];
                                  $date = $row['transaction_date'];
                          ?>
                          <tr style="text-align:center">
                              <td><?php echo $i++ ?></td>
                              <td><?php echo $username?></td>
                              <td><?php echo $currency ?><?php echo number_format("$amount",2)?></td>
                              <td><?php echo $gateway ?></td>
                              <td><?php echo $wallet_address ?></td>
                              <td>
                                <?php
                                  if($status == "pending"){
                                    echo "<span style='background:; border:0px' class='btn btn-warning btn-block btn-sm'>Pending</span>";
                                  }elseif($status == "success"){
                                    echo "<span style='color:;' class='btn btn-success btn-block btn-sm'>Success</span>";
                                  }elseif($status == "cancel"){
                                    echo "<span style='color:;' class='btn btn-danger btn-block btn-sm'>Cancelled</span>";
                                  }else{
                                    echo "<span style='color:;' class='btn btn-primary btn-block btn-sm'>N/A</span>";
                                  }
                                ?>
                              </td>
                              <td><?php echo $date?></td>
                          </tr>
                          <?php }?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>


    </div>
    <!-- * App Capsule -->

<?php include 'user_footer.php'; ?>
