<?php $page_title = "Deposit History" ?>
<?php include 'user_header.php';?>
        <!-- Stats -->
     <!-- Stats -->
<div class="section mt-4">
    <div class="section-heading d-flex justify-content-between align-items-center mb-3">
        <h2 class="title m-0">Statistics</h2>
    </div>

    <div class="row mt-2">
        <div class="col-6 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body">
                    <div class="title text-muted">Amount Pending</div>
                    <div class="value text-primary fw-bold"><?php echo $currency . $total_pend_deposit ?></div>
                </div>
            </div>
        </div>
        <div class="col-6 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body">
                    <div class="title text-muted">Amount Confirmed</div>
                    <div class="value text-success fw-bold"><?php echo $currency . $total_confirm_deposit ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-4 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body">
                    <div class="title text-muted">Pending</div>
                    <div class="value text-primary fw-bold"><?php echo $pending_inv ?></div>
                </div>
            </div>
        </div>
        <div class="col-4 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body">
                    <div class="title text-muted">Running</div>
                    <div class="value text-success fw-bold"><?php echo $running_inv ?></div>
                </div>
            </div>
        </div>
        <div class="col-4 mb-3">
            <div class="stat-box card h-100 shadow-sm">
                <div class="card-body">
                    <div class="title text-muted">Completed</div>
                    <div class="value text-primary fw-bold"><?php echo $completed_inv ?></div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- * Stats -->

<style>
    /* Section Styling */
.section {
    padding: 0 15px;
}

.section-heading .title {
    font-size: 1.5rem;
    font-weight: 600;
}

/* Stat Box Styling */
.stat-box {
    transition: transform 0.2s, box-shadow 0.2s;
}

.stat-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1) !important;
}

.stat-box .card-body {
    padding: 1.25rem;
}

.stat-box .title {
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 0.5rem;
}

.stat-box .value {
    font-size: 1.25rem;
}

/* Responsive Adjustments */
@media (max-width: 576px) {
    .section-heading .title {
        font-size: 1.3rem;
    }

    .row .col-6,
    .row .col-4 {
        flex: 0 0 100%;
        max-width: 100%;
    }

    .stat-box .value {
        font-size: 1.1rem;
    }
}
</style>



      <div class="section mt-2">
            <div class="section-title" style="text-align:center">Deposit Transactions</div>
            <div class="card">

                <div class="table-responsive">
                    <table class="table" style="width:100%">
                        <thead>
                            <tr>
                                <th style="color: black"; scope="col">S/N</th>
                                <th  style="color: black"; scope="col">Name</th>
                                <th  style="color: black"; scope="col">Amount</th>
                                <th  style="color: black"; scope="col">Capital + Profit</th>
                                <th  style="color: black"; scope="col">Profit</th>
                                <th  style="color: black"; scope="col">Status</th>
                                <th  style="color: black"; scope="col" class="">Date</th>
                                <th  style="color: black"; scope="col" class="">More details</th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php
                              $i = 1;
                              $sql = "SELECT * FROM invest_plan WHERE invest_user_id = '$user_id' ORDER BY id DESC";
                              $result = $connection->query($sql);
                              while ($row = $result->fetch_assoc()) {
                                  $invest_hash = $row['invest_hash'];
                                  $planName = $row['planName'];
                                  $roi = $row['roi'];
                                  $amount = $row['amount'];
                                  $duration = $row['duration'];
                                  $profit = $row['profit'];
                                  $start_date = $row['start_date'];
                                  $status = $row['status'];

                                  $return = $amount + $profit;
                          ?>
                          <tr style="text-align:center">
                              <td><?php echo $i++ ?></td>
                              <td><?php echo $username?></td>
                              <td><?php echo $currency ?><?php echo number_format("$amount",2)?></td>
                              <td><?php echo $currency ?><?php echo number_format("$return",2)?></td>
                              <td><?php echo $currency ?><?php echo number_format("$profit",2)?></td>
                              <td>
                                <?php
                                  if($status == "pending"){
                                    echo "<span style='background:; border:0px' class='btn btn-warning btn-block btn-sm'>Pending</span>";
                                  }elseif($status == "active"){
                                    echo "<span style='color:;' class='btn btn-primary btn-block btn-sm'>Running</span>";
                                  }elseif($status == "cancel"){
                                    echo "<span style='color:;' class='btn btn-danger btn-block btn-sm'>Cancelled</span>";
                                  }elseif($status == "completed"){
                                    echo "<span style='color:;' class='btn btn-success btn-block btn-sm'>Completed</span>";
                                  }else{
                                    echo "<span style='color:;' class='btn btn-secondary btn-block btn-sm'>N/A</span>";
                                  }
                                ?>
                              </td>
                              <td><?php echo $start_date?></td>
                              <td><a href="deposit-details.php?hash=<?php echo $invest_hash ?>" class="btn btn-primary btn-block btn-sm">details</a></td>
                          </tr>
                          <?php }?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>





    </div>
    <!-- * App Capsule -->

<?php include 'user_footer.php'; ?>
