<?php
include('includes/header.php');
include('includes/navbar.php');
?>

<div class="container-fluid">

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary" style="margin-bottom:5px">Add/Remove User Funds</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
              <?php
                  if (isset($_POST['topup'])) {
                      $userid = $_POST['id'];
                      $operator = $_POST['operator'];
                      $amount = $_POST['amount'];
                      $trxn_date = $_POST['trxn_date'];

                      $t_date = date("d M, Y");

                      if ($operator == "add") {
                        $mode = "Credit";
                        $description = "Bonus Topup";
                      }elseif ($operator == "substract") {
                        $mode = "Debit";
                        $description = "Account Charge Deduction";
                      }

                      //get old balance
                      $sql_bal = "SELECT * FROM users WHERE user_id = '$userid'";
                      $result = $connection->query($sql_bal);
                      while ($row = $result->fetch_assoc()) {
                          $old_balance = $row['balance'];
                          $uname = $row['full_name'];
                      }


                      if ($operator == "add") {
                        $transaction_type = "deposit";
                      }elseif ($operator == "substract") {
                        $transaction_type = "withdrawal";
                      }

                      if ($operator == "add") {
                        $new_balance = $old_balance + $amount;
                      }elseif ($operator == "substract") {
                        $new_balance = $old_balance - $amount;
                      }
                      $transaction_status = "success";
                      $character = '0123456789abcdefghijklmnopqrstuvwxyz';
                      $randomString = '';
                      for ($i=0; $i < 8; $i++) {
                          $index = rand(0, strlen($character) -1);
                          $randomString .=$character[$index];
                      }
                      $randomString;
                      $trnx_hash = "40660d1".''.$randomString;

                      if (empty($userid) || empty($operator) || empty($amount)) {
                        $error = "empty";
                      }else {
                        $sql = "UPDATE users SET balance = '$new_balance' WHERE user_id = '$userid'";
                        if ($connection->query($sql)===TRUE) {
                            $error = "balance_success";
                        }else {
                            $error = "error";
                          }
                      }
                  }

              ?>
              <form action="" method="POST">

                <div class="modal-body">

                    <div class="form-group">
                      <label for="">Select User </label>
                      <select name="id" style='color: var(--text); text-align: left' required class="form-control">
                          <option value="">Select Account </option>
                          <?php
                              $sql = "SELECT * FROM users WHERE id != 1";
                              $result = $connection->query($sql);
                              while ($row = $result->fetch_assoc()) {
                                  $db_name = $row['full_name'];
                                  $db_id = $row['user_id'];
                                  $db_email = $row['email'];
                                  $db_balance = $row['balance'];

                                  $d_bal = number_format("$db_balance",2);
                          ?>
                          <option value="<?php echo $db_id?>"><?php echo $db_name?> (<?php echo $db_email?>) <?php echo $currency.''.$d_bal ?></option>
                          <?php }?>
                      </select>
                    </div>

                    <div class="form-group">
                        <label for="">Select Operator</label>
                        <select name="operator" required class="form-control">
                            <option value="">Select Action</option>
                            <option value="add">Add Funds</option>
                            <option value="substract">Substract Funds</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="">Amount</label>
                        <input type="text" class="form-control" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" placeholder="Enter amount to add/substract" required>
                    </div>

                    <div class="form-group" style="display:none">
                        <label for="">Date</label>
                        <input type="date" class="form-control" name="trxn_date" placeholder="Enter date of transaction" required disabled>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" name="topup" class="btn btn-primary">Submit</button>
                </div>
              </form>

            </div>
        </div>
    </div>



    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary" style="margin-bottom:5px">Add/Remove User Profit/earning</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
              <?php
                  if (isset($_POST['update_earn'])) {
                      $userid = $_POST['id'];
                      $operator = $_POST['operator'];
                      $amount = $_POST['amount'];
                      $trxn_date = $_POST['trxn_date'];

                      $t_date = date("d M, Y");

                      if ($operator == "add") {
                        $mode = "Credit";
                        $description = "Profit Earned";
                      }elseif ($operator == "substract") {
                        $mode = "Debit";
                        $description = "Profit Charge Deduction";
                      }

                      //get old balance
                      $sql_bal = "SELECT * FROM users WHERE user_id = '$userid'";
                      $result = $connection->query($sql_bal);
                      while ($row = $result->fetch_assoc()) {
                          $old_profit= $row['profit'];
                          $uname = $row['full_name'];
                      }


                      if ($operator == "add") {
                        $transaction_type = "profit";
                      }elseif ($operator == "substract") {
                        $transaction_type = "profit";
                      }

                      if ($operator == "add") {
                        $new_profit = $old_profit + $amount;
                      }elseif ($operator == "substract") {
                        $new_profit = $old_profit - $amount;
                      }
                      $transaction_status = "success";
                      $character = '0123456789abcdefghijklmnopqrstuvwxyz';
                      $randomString = '';
                      for ($i=0; $i < 8; $i++) {
                          $index = rand(0, strlen($character) -1);
                          $randomString .=$character[$index];
                      }
                      $randomString;
                      $trnx_hash = "40660d1".''.$randomString;

                      if (empty($userid) || empty($operator) || empty($amount)) {
                        $error = "empty";
                      }else {
                        $sql = "UPDATE users SET profit = '$new_profit' WHERE user_id = '$userid'";
                        if ($connection->query($sql)===TRUE) {
                            $error = "profit_success";
                        }else {
                            $error = "error";
                          }
                      }
                  }

              ?>
              <form action="" method="POST">

                <div class="modal-body">

                    <div class="form-group">
                      <label for="">Select User </label>
                      <select name="id" style='color: var(--text); text-align: left' required class="form-control">
                          <option value="">Select Account </option>
                          <?php
                              $sql = "SELECT * FROM users WHERE id != 1";
                              $result = $connection->query($sql);
                              while ($row = $result->fetch_assoc()) {
                                  $db_name = $row['full_name'];
                                  $db_id = $row['user_id'];
                                  $db_email = $row['email'];
                                  $db_profit = $row['profit'];

                                  $d_profit = number_format("$db_profit",2);
                          ?>
                          <option value="<?php echo $db_id?>"><?php echo $db_name?> (<?php echo $db_email?>) <?php echo $currency.''.$d_profit ?></option>
                          <?php }?>
                      </select>
                    </div>

                    <div class="form-group">
                        <label for="">Select Operator</label>
                        <select name="operator" required class="form-control">
                            <option value="">Select Action</option>
                            <option value="add">Add Profit</option>
                            <option value="substract">Substract Profit</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="">Amount</label>
                        <input type="text" class="form-control" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" placeholder="Enter amount to add/substract" required>
                    </div>

                    <div class="form-group" style="display:none">
                        <label for="">Date</label>
                        <input type="date" class="form-control" name="trxn_date" placeholder="Enter date of transaction" required disabled>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" name="update_earn" class="btn btn-primary">Submit</button>
                </div>
              </form>

            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->
<p id="error" style='display: none '><?php echo $error?></p>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    var error = document.getElementById('error');

    if (error.textContent == "empty") {
      swal("EMPTY FIELD!", "Fill out all fields", "warning");

    }else if (error.textContent == "balance_success") {
      swal("Successful!", "User account balance updated successfully", "success");
        setTimeout(() => {
            window.location.href = 'fund_user.php'
        }, 2000);
    }else if (error.textContent == "profit_success") {
      swal("Successful!", "User profit balance updated successfully", "success");
        setTimeout(() => {
            window.location.href = 'fund_user.php'
        }, 2000);
    }else if (error.textContent == "error") {
      swal("ERROR!", "Sorry!!!, Something went wrong, try later or contact support", "error");
    }

</script>
<?php
include('includes/scripts.php');
include('includes/footer.php');
?>
